"""
Module template to configure generator for simulated data by PyRunner

HOW TO USE
----------
In the HAL.sim configuration file set the setting [Application].MeasSimPath
to the path of this file.

Update the code of the individual methods in this file to change the returned values
"""


from meas_services.trf import TRFSignalData
from meas_services.fp import FPData
from meas_services.fi import FIData
from meas_services.abs import ABSFData


def trf_meas(xwell, ywell, windows, xscan, yscan, iteration, measurementTime) :
    signal = xwell + ywell

    pmt1signals = list()
    pmt2signals = list()
    for i in range(windows):
        pmt1signals.append( signal * (i+1) * iteration)
        pmt2signals.append( signal * (i+2) * iteration)
    refSignal = 42

    return TRFSignalData(refSignal, pmt1signals, pmt2signals, ())


def fi_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime):
    pmt1signal = xwell + ywell * iteration
    pmt2signal = pmt1signal * 2 * iteration
    if xscan != None and yscan != None:
        pmt1signal = pmt1signal + (xscan * yscan)
        pmt2signal = pmt2signal + (xscan * yscan)

    refSignal = 42
    return FIData(pmt1signal, pmt2signal, refSignal, ())

def fi_mono_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime, exitation_wavelength , emmision_wavelength):
    pmt1signal = xwell + ywell * iteration
    pmt2signal = pmt1signal * 2 * iteration
    if xscan != None and yscan != None:
        pmt1signal = pmt1signal + (xscan * yscan)
        pmt2signal = pmt2signal + (xscan * yscan)

    refSignal = 42
    return FIData(exitation_wavelength, emmision_wavelength, refSignal, ())


def fp_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime):
    pmt1signal = xwell + ywell
    pmt2signal = pmt1signal * 2
    refSignal = 42
    return FPData(pmt1signal, pmt2signal, refSignal, ())


def lum_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime):
    signal = xwell + ywell * 1000 * measurementTime

    return (signal, (signal, 0, 0, 0, 2 * signal, 0, 0, 0))

def lum_mono_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime, emmision_wavelength):
    signal = xwell + ywell * 1000 * measurementTime + emmision_wavelength

    return (signal, 2 * signal, (signal, 0, 0, 0, 2 * signal, 0, 0, 0))


def uslum_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime):
    signal = xwell + ywell * 1000 * measurementTime

    return (signal, (0, 0))


def alpha_meas(xwell, ywell, xscan, yscan, iteration,  excitationTime, detectionTime):
    signal = xwell + ywell
    return (signal, 2 * signal, signal, signal *2, signal*0.01)

def alphaus_meas(xwell, ywell, xscan, yscan, iteration, excitationTime, detectionTime):
    signal = xwell + ywell
    return (signal, (0,0))


def abs_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime):
    background = 4000
    refBackground = 6000

    signal = xwell * ywell
    refSignal = 7000

    return ABSFData(signal, refSignal, background, refBackground)

def abs_mon_meas(xwell, ywell, xscan, yscan, iteration,  measurementTime, exitation_wavelength , emmision_wavelength):
    background = 4000
    refBackground = 6000

    signal = xwell * ywell + exitation_wavelength
    refSignal = 7000

    return ABSFData(signal, refSignal, background, refBackground)



def sleep_service(delay):
    pass
